<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

include("include/dbcommon.php");

// ✅ Block access to menu.php unless logged in
if (!isLogged()) {
    HeaderRedirect("login.php");
    exit();
}
?>
<!DOCTYPE html>
<html {$html_attrs}>
<head>
   
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{$pagetitle}</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <base href="{$projectPath}">
  <link REL="stylesheet" href="styles/default.css?{$wizardBuildKey}" type="text/css">
  {BEGIN rtlCSS}
  <link REL="stylesheet" href="styles/defaultRTL.css?{$wizardBuildKey}" type="text/css">
  {END rtlCSS}
 
  <style>
/* ===================================================================
   GLOBAL STYLES
=================================================================== */
body {
font-family: Arial, sans-serif;
background: #f8f9fa;
margin: 0;
padding: 10px 0 0;
}

/* ===================================================================
   HEADER + NAVIGATION
=================================================================== */
header,
.custom-navbar {
background: #1E1E1E;
color: white;
backdrop-filter: blur(5px);
font-family: Arial, sans-serif;
}

header {
padding: 20px;
text-align: center;
position: sticky;
top: 60px;
z-index: 999;
transition: box-shadow 0.3s ease;
}

header.shrink {
padding: 10px 20px;
}

header.shadow {
box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}

header.hidden {
transform: translateY(-100%);
}

.custom-navbar {
display: flex;
justify-content: space-between;
align-items: center;
padding: 10px 20px;
position: sticky;
top: 0;
z-index: 1000;
transition: box-shadow 0.3s ease;
}


/* ===================================================================
   PROFILE DROPDOWN
=================================================================== */
.profile-wrapper {
position: absolute;
top: 20px;
right: 30px;
z-index: 1000;
}

.profile-btn, .dropdown-btn {
background-color: transparent;
color: #ffffff;
font-weight: bold;
border: none;
font-size: 14px;
cursor: pointer;
}

.dropdown-content {
display: none;
position: absolute;
right: 0;
background-color: white;
min-width: 160px;
border-radius: 6px;
box-shadow: 0px 8px 16px rgba(0,0,0,0.2);
z-index: 9999;
color: #333;
}

.dropdown-content a {
color: #004080;
padding: 12px 16px;
text-decoration: none;
display: block;
font-size: 14px;
}

.dropdown-content a:hover {
background-color: #f1f1f1;
}

.show {
display: block;
}

/* ===================================================================
   LOGO + NAVIGATION LINKS
=================================================================== */
.logo {
height: 100px;
transition: transform 0.3s ease, height 0.3s ease;
}

.logo.shrink {
transform: scale(0.8);
height: 50px;
}

.brand-title {
font-size: 18px;
font-weight: bold;
color: #fff;
}

.nav-left {
display: flex;
align-items: center;
}

.nav-center a {
margin: 0 12px;
color: #fff;
text-decoration: none;
font-weight: 500;
}

.nav-center a:hover {
text-decoration: underline;
}

.nav-right {
position: relative;
}

/* ===================================================================
   CHART SECTION
=================================================================== */

.chart-row {
width: 100%;
background: #fff;
padding: 40px 20px;
box-shadow: 0 2px 8px rgba(0,0,0,0.05);
margin-bottom: 40px;
transition: max-height 0.5s ease, opacity 0.5s ease;
overflow: hidden;
}

.chart-container {
max-width: 1200px;
margin: auto;
}

.chart-row.hidden {
max-height: 0;
opacity: 0;
padding: 0 !important;
margin-bottom: 0 !important;
}

.toggle-chart-btn {
background-color: #dc3545;
color: white;
border: none;
padding: 6px 12px;
font-size: 14px;
border-radius: 4px;
cursor: pointer;
margin-right: 10px;
}
   
.toggle-chart-btn:hover {
background-color: #c82333;
}
   
/* ===================================================================
   JOB CARD STYLES
=================================================================== */  
/* ================= JOB CARD BACKGROUND LOGO STYLES ================= */

.job-card {
  position: relative;
  overflow: hidden;
}

/* 🔁 Shared ::before layout for all logos */
.job-card::before {
  content: "";
  position: absolute;
  bottom: 0;
  right: 0;
  width: 100%;
  height: 100%;
  z-index: 1;
  background-position: bottom right;
  background-repeat: no-repeat;
  background-size: 100px auto;
  pointer-events: none;
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.95), rgba(255,255,255,0)),
    url('images/logos/default.png'); /* fallback */
}

/* ✅ Logo overrides */
.card-sprep::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.95), rgba(255,255,255,0)),
    url('images/logos/sprep_logo.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-govt::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.95), rgba(255,255,255,0)),
    url('images/logos/govt.png');
    background-size: 50px auto; /* 👈 adjust logo size */
}

.card-undp::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.95), rgba(255,255,255,0)),
    url('images/logos/undp.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-spc::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.95), rgba(255,255,255,0)),
    url('images/logos/spc.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-pifs::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.95), rgba(255,255,255,0)),
    url('images/logos/pifs.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-ffa::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.95), rgba(255,255,255,0)),
    url('images/logos/ffa.png');
    background-size: 70px auto; /* 👈 adjust logo size */
}

.card-himalayas::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.6), rgba(255,255,255,0)),
    url('images/logos/himalayas.png');
}


.badge-closing-inline {
  display: inline-block;
  padding: 2px 8px;
  font-size: 11px;
  border-radius: 4px;
  margin-left: 8px;
  font-weight: bold;
  vertical-align: middle;
}

.urgent-red {
  background-color: #dc3545;
  color: #fff;
}

.closing-soon-animated {
  margin-left: 8px;
  color: #dc3545;
  font-weight: bold;
  font-size: 13px;
  transition: transform 0.3s ease, font-size 0.3s ease;
}

.closing-soon-animated:hover {
  transform: translateY(-2px) scale(1.05);
  font-size: 14px;
}

.expired-tag {
  margin-left: 6px;
  color: #6c757d;
  background-color: #e2e3e5;
  font-size: 13px;
  font-weight: bold;
  padding: 4px 8px;
  border-radius: 4px;
}

.expired-card {
  opacity: 0.6;
  filter: grayscale(20%);
/*  pointer-events: none;  optional: disable clicks */
}

.grace-message {
  display: inline-block;
  margin-left: 6px;
  font-size: 13px;
  color: #856404;
  background-color: #fff3cd;
  border-left: 4px solid #fd7e14;
  padding: 4px 8px;
  border-radius: 4px;
}


.no-local-jobs {
  background: #fff6f6;
  border: 1px solid #f5c2c7;
  color: #842029;
  padding: 20px 30px;
  border-radius: 12px;
  text-align: center;
  box-shadow: 0 2px 6px rgba(0,0,0,0.05);
  font-family: 'Segoe UI', sans-serif;
  max-width: 700px;
  margin: 40px auto;
  position: relative;
  transition: all 0.4s ease-in-out;
}

.dismiss-btn {
  position: absolute;
  top: 10px;
  right: 15px;
  border: none;
  background: transparent;
  font-size: 18px;
  color: #d63384;
  cursor: pointer;
  transition: opacity 0.3s;
}
.dismiss-btn:hover {
  opacity: 0.6;
}


.no-local-jobs h3 {
  font-size: 1.5rem;
  color: #d63384;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
}

.no-local-jobs p {
  font-size: 1rem;
  line-height: 1.5;
  margin-top: 10px;
}






.jobs-grid {
display: flex;
flex-wrap: wrap;
gap: 20px;
justify-content: center;
padding: 40px 20px;
}
   
.job-card {
background: #fff;
border-radius: 10px;
box-shadow: 0 4px 10px rgba(0,0,0,0.1);
padding: 20px;
width: 280px;
border-left: 5px solid #007BFF;
position: relative;
z-index: 2;
transition: all 0.3s ease;
overflow: hidden;
min-height: 180px;
}

.job-card:hover {
transform: translateY(-8px);
box-shadow: 0 8px 20px rgba(0,0,0,0.2);
}

.job-description {
opacity: 0;
max-height: 0;
overflow: hidden;
transition: all 0.3s ease;
font-size: 13px;
color: #444;
margin-top: 10px;
}

.job-card:hover .job-description {
opacity: 1;
max-height: 150px;
}

.job-card h3 {
margin-top: 0;
font-size: 18px;
color: #007BFF;
}

.job-card p {
margin: 4px 0;
font-size: 14px;
}




.dropdown-btn {
  background: transparent;
  border: none;
  color: white;
  font-size: 14px;
  cursor: pointer;
}

.dropdown-content {
  display: none;
  position: absolute;
  right: 0;
  background-color: white;
  color: #333;
  min-width: 180px;
  border-radius: 6px;
  box-shadow: 0 8px 16px rgba(0,0,0,0.15);
  z-index: 9999;
}

.dropdown-content a {
  color: #004080;
  padding: 12px 16px;
  text-decoration: none;
  display: block;
}

.dropdown-content a:hover {
  background-color: #f1f1f1;
}

.show {
  display: block;
}




.filter-btn {
  background-color: #f8f9fa;
  color: #333;
  border: 1px solid #ccc;
  padding: 8px 16px;
  border-radius: 20px;
  font-size: 14px;
  cursor: pointer;
  transition: background-color 0.3s ease, transform 0.2s ease;
  display: inline-block;
  font-weight: 500;
  min-width: 120px;
  text-align: center;
}

.filter-btn:hover {
  background-color: #e2e6ea;
  transform: translateY(-2px);
}

 
  .filter-btn.red { background-color: #dc3545; color: white; }
.filter-btn.red:hover { background-color: #c82333; }

.filter-btn.blue { background-color: #007BFF; color: white; }
.filter-btn.blue:hover { background-color: #0056b3; }

.filter-btn.green { background-color: #28a745; color: white; }
.filter-btn.green:hover { background-color: #1e7e34; }

.filter-btn.purple { background-color: #6f42c1; color: white; }
.filter-btn.purple:hover { background-color: #563d7c; }

  .btn-blue {
    background-color: #007BFF;
    color: white;
    border-color: #007BFF;
  }

  .btn-green {
    background-color: #28a745;
    color: white;
    border-color: #28a745;
  }

  .btn-purple {
    background-color: #6f42c1;
    color: white;
    border-color: #6f42c1;
  }

  .btn-blue:hover {
    background-color: #0056b3;
  }

  .btn-green:hover {
    background-color: #1e7e34;
  }

  .btn-purple:hover {
    background-color: #563d7c;
  }

    /* popup modal styles start */
      #customModal {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0,0,0,0.6);
      z-index: 9999;
      align-items: center;
      justify-content: center;
    }
    .modal-content {
      background: white;
      padding: 30px;
      border-radius: 14px;
      max-width: 1100px;
      width: 95%;
      position: relative;
      height: 90vh;
      overflow: hidden;
      display: flex;
      flex-direction: column;
      box-shadow: 0 10px 40px rgba(0,0,0,0.25);
      animation: slideIn 0.3s ease-out;
    }
    .modal-content iframe {
      /*flex: 1;*/
      width: 100%;
      border: none;
    }
    .modal-close {
      position: absolute;
      top: 10px;
      right: 10px;
      background: #e74c3c;
      border: none;
      color: white;
      padding: 8px 12px;
      cursor: pointer;
      border-radius: 6px;
      font-size: 16px;
      z-index: 10;
    }
    @keyframes slideIn {
      from { transform: translateY(-30px); opacity: 0; }
      to { transform: translateY(0); opacity: 1; }
    }
   
    .load-more-container {
      text-align: center;
      margin-bottom: 40px;
    }
    .load-more-btn {
      padding: 10px 20px;
      font-size: 14px;
      background-color: #007BFF;
      color: white;
      border: none;
      border-radius: 6px;
      cursor: pointer;
    }
    .load-more-btn:hover {
      background-color: #0056b3;
    }
   
   
     /* Make UI Mobile-Friendly */
    @media (max-width: 600px) {
  .dashboard, .jobs-grid {
    flex-direction: column;
    align-items: center;
  }
  .card, .job-card {
    width: 100%;
    max-width: 90%;
  }
}

.custom-navbar {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background-color: #1E1E1E;
  color: white;
  padding: 10px 20px;
  font-family: Arial, sans-serif;

  /* Sticky behavior */
  position: sticky;
  top: 0;
  z-index: 1000;
 
  transition: box-shadow 0.3s ease;
}
 
 
 .apply-now-btn {
  position: absolute;
  top: 10px;
  right: 10px;
  background-color: #28a745;
  color: white;
  font-size: 13px;
  padding: 6px 10px;
  border-radius: 5px;
  text-decoration: none;
  z-index: 10;
}
.apply-now-btn:hover {
  background-color: #218838;
}


.toggle-desc {
  display: inline-block;
  margin-left: 8px;
  color: #007BFF;
  cursor: pointer;
  font-size: 13px;
}
.toggle-desc:hover {
  text-decoration: underline;
}





  .guest-slide-popup {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: #f9f9ff;
    border-left: 4px solid #007BFF;
    border-radius: 10px;
    padding: 20px 20px 15px;
    width: 90%;
    max-width: 360px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.15);
    z-index: 9999;
    animation: slideInUp 0.5s ease;
  }
  .guest-popup-content h3 {
    margin: 0 0 8px;
    font-size: 16px;
    color: #007BFF;
  }
  .guest-popup-content p {
    font-size: 14px;
    margin: 4px 0;
  }
  .guest-popup-buttons {
    margin-top: 10px;
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
  }
  .guest-popup-buttons button {
    background-color: #007BFF;
    color: white;
    border: none;
    padding: 6px 12px;
    font-size: 13px;
    border-radius: 5px;
    cursor: pointer;
    /*flex: 1;*/
  }
  .guest-popup-buttons button:hover {
    background-color: #0056b3;
  }
  .guest-popup-close {
    position: absolute;
    top: 8px;
    right: 12px;
    font-size: 18px;
    background: none;
    border: none;
    cursor: pointer;
    color: #666;
  }
  @keyframes slideInUp {
    from { transform: translate(-50%, calc(-50% + 30px)); opacity: 0; }
    to { transform: translate(-50%, -50%); opacity: 1; }
  }
 
   .guest-slide-popup {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: #f9f9ff;
    border-left: 4px solid #007BFF;
    border-radius: 10px;
    padding: 20px 20px 15px;
    width: 90%;
    max-width: 360px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.15);
    z-index: 9999;
    animation: slideInUp 0.5s ease;
  }
  .guest-popup-content h3 {
    margin: 0 0 8px;
    font-size: 16px;
    color: #007BFF;
  }
  .guest-popup-content p {
    font-size: 14px;
    margin: 4px 0;
  }
  .guest-popup-buttons {
    margin-top: 10px;
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
  }
  .guest-popup-buttons button {
    background-color: #007BFF;
    color: white;
    border: none;
    padding: 6px 12px;
    font-size: 13px;
    border-radius: 5px;
    cursor: pointer;
    /*flex: 1;*/
  }
  .guest-popup-buttons button:hover {
    background-color: #0056b3;
  }
  .guest-popup-close {
    position: absolute;
    top: 8px;
    right: 12px;
    font-size: 18px;
    background: none;
    border: none;
    cursor: pointer;
    color: #666;
  }
  @keyframes slideInUp {
    from { transform: translate(-50%, calc(-50% + 30px)); opacity: 0; }
    to { transform: translate(-50%, -50%); opacity: 1; }
  }
 
 
 
 
 

  .apply-message-popup {
      position: absolute;
      top: 40px;
      right: 10px;
      background: #fff;
      border: 1px solid #ccc;
      border-left: 4px solid #28a745;
      padding: 10px;
      border-radius: 8px;
      font-size: 13px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.1);
      display: none;
      z-index: 999;
      width: 220px;
    }
   
   
  .apply-message-popup button {
      margin-top: 8px;
      padding: 6px 10px;
      background: #28a745;
      color: white;
      border: none;
      border-radius: 4px;
      font-size: 12px;
      cursor: pointer;
    }

    /* Modal backdrop */
  #remoteJobModal {
    display: none;
    position: fixed;
    z-index: 9999;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: rgba(0, 0, 0, 0.6);
    align-items: center;
    justify-content: center;
  }

  /* Modal content box */
  #remoteJobModal .modal-content {
    position: relative;
    width: 90%;
    max-width: 900px;
    height: 80vh;
    background: #fff;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 4px 16px rgba(0,0,0,0.3);
  }

  /* Close button */
  #remoteJobModal .modal-close {
    position: absolute;
    top: 8px; right: 12px;
    background: #e74c3c;
    color: #fff;
    border: none;
    border-radius: 50%;
    width: 30px; height: 30px;
    font-size: 18px;
    cursor: pointer;
    z-index: 10;
    line-height: 30px;
    text-align: center;
  }

  /* Iframe styling */
  #remoteJobModal iframe {
    width: 100%;
    height: 100%;
    border: none;
  }
   
   /* ─────────────────────────────────────────────────────────────────────────────
   Style for the “View Job” button on remote job cards
   ───────────────────────────────────────────────────────────────────────────── */
.view-job-btn {
  background-color: #007bff;
  color: white;
  padding: 6px 12px;
  border-radius: 6px;
  display: inline-block;
  text-decoration: none;
}
.view-job-btn:hover {
  background-color: #0056b3;
}


.page-link.active {
  background-color: #0056b3;
  font-weight: bold;
}


#externalJobs {
  transition: opacity 0.3s ease-in-out;
}


.loader {
  text-align: center;
  font-weight: bold;
  font-size: 18px;
  margin-top: 20px;
}
.loader .dot {
  animation: dotBlink 1.5s infinite;
}
.loader .dot:nth-child(2) {
  animation-delay: 0.2s;
}
.loader .dot:nth-child(3) {
  animation-delay: 0.4s;
}

@keyframes dotBlink {
  0%, 20% { opacity: 0; }
  50% { opacity: 1; }
  100% { opacity: 0; }
}


.dot-loader {
  display: flex;
  justify-content: center;
  align-items: center;
  margin: 30px auto;
  height: 40px;
  gap: 8px;
}

.dot-loader span {
  width: 12px;
  height: 12px;
  background-color: #007bff;
  border-radius: 50%;
  animation: dotBounce 1.2s infinite ease-in-out;
}

.dot-loader span:nth-child(1) {
  animation-delay: 0s;
}
.dot-loader span:nth-child(2) {
  animation-delay: 0.2s;
}
.dot-loader span:nth-child(3) {
  animation-delay: 0.4s;
}

@keyframes dotBounce {
  0%, 80%, 100% {
    transform: scale(0.6);
    opacity: 0.3;
  }
  40% {
    transform: scale(1);
    opacity: 1;
  }
}
 
  .job-board-wrapper {
  display: flex;
  flex-direction: column;
  gap: 50px;
  padding: 20px;
  max-width: 1200px;
  margin: auto;
}

.board-section {
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.05);
  padding: 20px;
}

.board-section h3 {
  margin-top: 0;
  font-size: 20px;
  color: #007BFF;
  border-left: 4px solid #007BFF;
  padding-left: 10px;
}

 .location-preview,
.location-full {
  display: inline;
}

/*--------------------------------------------------------------------------------------*/
/* 🌐 Floating Button with label */
.floating-disclaimer-trigger {
  display: none;
  position: fixed;
  padding: 8px 16px;
  background: #0d6efd;
  color: #fff;
  font-weight: bold;
  font-size: 14px;
  border-radius: 30px;
  cursor: pointer;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
  z-index: 9999;
  transition: all 0.3s ease;
}

.floating-right-buttons {
  position: fixed;
  right: 20px;
  top: 240px;
  display: flex;
  flex-direction: column;
  gap: 10px;
  z-index: 9999;
}

.floating-right-buttons button,
.logout-btn {
  padding: 8px 16px;
  background-color: #007bff;
  color: white;
  font-size: 13px;
  border: none;
  border-radius: 20px;
  cursor: pointer;
  box-shadow: 0 2px 6px rgba(0,0,0,0.2);
  text-decoration: none;
  text-align: center;
}
.floating-right-buttons button:hover,
.logout-btn:hover {
  background-color: #0056b3;
}

.floating-panel {
  position: fixed;
  right: 20px;
  z-index: 9999;
  display: flex;
  flex-direction: column;
  align-items: flex-end;
  transition: all 0.3s ease;
}

/* Top position (desktop) */
@media (min-width: 768px) {
  .floating-panel {
    top: 140px;
  }
}

/* Bottom position (mobile) */
@media (max-width: 767px) {
  .floating-panel {
    bottom: 80px;
  }
}

.panel-toggle {
  background: #0d6efd;
  color: white;
  border: none;
  padding: 6px 14px;
  border-radius: 20px;
  font-size: 16px;
  cursor: pointer;
  box-shadow: 0 2px 6px rgba(0,0,0,0.2);
  margin-bottom: 8px;
}

.panel-buttons {
  display: none;
  flex-direction: column;
  gap: 8px;
  align-items: flex-end;
  animation: slideDown 0.3s ease-out;
}

.panel-buttons button,
.logout-btn {
  background: #007bff;
  color: white;
  padding: 8px 16px;
  border: none;
  border-radius: 20px;
  font-size: 13px;
  cursor: pointer;
  box-shadow: 0 2px 6px rgba(0,0,0,0.2);
  text-decoration: none;
}

.logout-btn:hover,
.panel-buttons button:hover {
  background: #0056b3;
}

.floating-panel.expanded .panel-buttons {
  display: flex;
}

@keyframes slideDown {
  from { opacity: 0; transform: translateY(-10px); }
  to   { opacity: 1; transform: translateY(0); }
}


/*ananei*/

/*.floating-disclaimer-trigger:hover {
  transform: scale(1.1);
}*/

/*.floating-disclaimer-trigger:hover {
  transform: scale(1.05);
  box-shadow: 0 6px 14px rgba(0,0,0,0.3);
}*/

/*.floating-disclaimer-trigger {
  display: inline-block;
  padding: 10px 16px;
  font-size: 14px;
  font-weight: bold;
  background: linear-gradient(to right, #007bff, #0056b3);
  color: #fff;
  border: none;
  border-radius: 999px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.2);
  backdrop-filter: blur(8px);
  transition: all 0.3s ease;
}

.floating-disclaimer-trigger:hover {
  animation: pulseGlow 0.8s ease-out;
}*/

/*.floating-disclaimer-trigger {
  position: fixed;
  right: 20px;
  top: 50%;
  transform: translateY(-50%);
  width: 45px;
  height: 45px;
  background: linear-gradient(135deg, #007bff, #0056b3);
  color: white;
  font-size: 22px;
  font-weight: bold;
  text-align: center;
  line-height: 45px;
  border-radius: 50%;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
  cursor: pointer;
  z-index: 9999;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}*/

.floating-disclaimer-trigger:hover {
  transform: translateY(-50%) scale(1.1);
  box-shadow: 0 6px 16px rgba(0, 123, 255, 0.4);
}*/


@keyframes pulseGlow {
  0% { box-shadow: 0 0 0 rgba(0, 123, 255, 0.5); }
  50% { box-shadow: 0 0 15px rgba(0, 123, 255, 0.7); }
  100% { box-shadow: 0 0 0 rgba(0, 123, 255, 0); }
}

/* 📢 Popup centered in screen */
.disclaimer-popup-centered {
  display: none;
  position: fixed;
  top: 50%;
  left: 50%;
  width: 90%;
  max-width: 500px;
  background: #e7f3ff;
  color: #084298;
  border: 1px solid #b6d4fe;
  border-radius: 12px;
  padding: 20px;
  z-index: 9999;
  transform: translate(-50%, -50%);
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
}


/* 🗨️ Disclaimer Box */
.disclaimer-popup-box {
  display: none;
  position: fixed;
  bottom: 160px;
  right: 20px;
  width: 300px;
  max-width: 90%;
  background-color: #e7f3ff;
  color: #084298;
  border: 1px solid #b6d4fe;
  border-radius: 12px;
  box-shadow: 0 6px 20px rgba(0,0,0,0.1);
  padding: 20px;
  z-index: 9999;
}

.disclaimer-popup-centered h4 {
  margin-top: 0;
  font-size: 16px;
}

.disclaimer-popup-centered p {
  font-size: 13px;
  margin-bottom: 10px;
}

.disclaimer-popup-box p {
  font-size: 13px;
  margin-bottom: 10px;
}

/* 💻 Desktop Position: right center */
@media (min-width: 768px) {
  .floating-disclaimer-trigger {
    right: 20px;
    top: 50%;
    transform: translateY(-50%);
  }
}

/* 📱 Mobile Position: bottom right */
@media (max-width: 767px) {
  .floating-disclaimer-trigger {
    bottom: 80px;
    right: 20px;
    transform: none;
  }
}
 
 .disclaimer-settings-wrapper {
  display: flex;
  justify-content: center;
  align-items: center;
  margin: 40px auto;
  padding-bottom: 60px;
}

.disclaimer-settings-card {
  background-color: #f8f9fa;
  border: 1px solid #ddd;
  padding: 20px 30px;
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.05);
  max-width: 400px;
  text-align: center;
}

.disclaimer-settings-card h5 {
  font-size: 16px;
  font-weight: bold;
  margin-bottom: 12px;
  color: #333;
}

.disclaimer-settings-card button {
  margin-top: 10px;
}

/*--------------------------------------------------------------------------*/

.highlight-top {
  animation: headerBounceGlow 0.8s ease;
  box-shadow: 0 0 12px rgba(0, 123, 255, 0.6);
}

@keyframes headerBounceGlow {
  0%   { transform: translateY(0); box-shadow: 0 0 0 rgba(0,123,255,0); }
  25%  { transform: translateY(-12px); }
  50%  { transform: translateY(0); box-shadow: 0 0 15px rgba(0,123,255,0.8); }
  75%  { transform: translateY(-6px); }
  100% { transform: translateY(0); box-shadow: 0 0 0 rgba(0,123,255,0); }
}

/*--------------------------------------------------------------------------*/
/* ✨ Bounce + Glow for job cards */
.job-card.highlight-card {
  animation: cardBounceGlow 0.8s ease;
  box-shadow: 0 0 12px rgba(40, 167, 69, 0.6); /* green glow */
}

@keyframes cardBounceGlow {
  0%   { transform: translateY(0); box-shadow: 0 0 0 rgba(40,167,69,0); }
  25%  { transform: translateY(-10px); }
  50%  { transform: translateY(0); box-shadow: 0 0 16px rgba(40,167,69,0.8); }
  75%  { transform: translateY(-4px); }
  100% { transform: translateY(0); box-shadow: 0 0 0 rgba(40,167,69,0); }
}

/*--------------------------------------------------------------------------*/

.alert-close-btn {
  position: absolute;
  top: 10px;
  right: 14px;
  background: transparent;
  border: none;
  padding: 4px;
  cursor: pointer;
  border-radius: 50%;
  transition: background-color 0.2s ease, transform 0.2s ease;
}

.alert-close-btn:hover {
  background-color: rgba(214, 51, 132, 0.1); /* Soft pink glow */
  transform: scale(1.1);
}

.alert-close-btn svg {
  display: block;
}
/*-------------------------------------------------------------------------12/06/2025-*/

.badge {
  display: inline-block;
  padding: 4px 8px;
  border-radius: 8px;
  font-size: 12px;
  margin: 2px;
}

.badge.active { background: #c8f7c5; color: #1a7f37; }
.badge.expired { background: #fddede; color: #d93025; }
.badge.archived { background: #e0e0e0; color: #555; }

.drag-icon {
  font-size: 12px;
  opacity: 0.5;
  cursor: move;
  user-select: none;
}

.drag-back {
  position: absolute;
  bottom: 6px;
  right: 8px;
}

/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/

/* ===================================================================
   DASHBOARD CARDS
=================================================================== */
.dashboard {
  display: flex;
  flex-wrap: wrap;
  gap: 12px;
  justify-content: center;
  padding: 10px;
  transition: all 0.3s ease;
}

.dashboard-toggle-btn {
  position: fixed;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  background: #b45309;
  color: white;
  padding: 10px 28px;
  border: none;
  border-top: 6px solid orange;
  font-weight: bold;
  border-radius: 12px 12px 0 0;
  box-shadow: 0 -4px 8px rgba(0,0,0,0.15);
  cursor: pointer;
  z-index: 999;
  transition: all 0.3s ease;
}

.dashboard-toggle-btn.top {
  position: relative;
  margin: 10px 8px;
  top: auto;
  left: auto;
  transform: none;
  border-radius: 6px;
  padding: 6px 16px;
  font-size: 13px;
  border-top: none;
  box-shadow: 0 2px 6px rgba(0,0,0,0.1);
  display: inline-block;
  background-color: #b45309;
  color: white;
}


.dashboard-hidden,
.dashboard-charts-hidden,
.dashboard-filters-hidden {
  display: none;
  position: relative;
}

#dashboardCharts,
#dashboardFilters {
  transition: all 0.3s ease;
}

.chart-container-user-posted {
  width: 100%;
  height: 300
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  position: relative;
  margin: 0 auto;
}

.chart-container-user-posted h4 {
  margin-bottom: 8px;
  font-size: 16px;
  text-align: center;
  color: #333;
}


.card {
  background: #ffffff;
  border-radius: 16px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.08);
  padding: 16px;
  flex: 1 1 300px;
  max-width: 300px;
  min-width: 260px; /* ✅ Much more appropriate */
  text-align: center;
  transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.card:hover {
  transform: translateY(-5px);
  box-shadow: 0 8px 16px rgba(0,0,0,0.15);
}

.card h4 {
  margin: 0 0 12px;
  color: #004080;
  font-size: 16px;
  font-weight: 600;
  text-transform: uppercase;
}

.card p {
  margin: 4px 0;
  font-size: 16px;
  font-weight: 500;
  color: #333;
}

.flip-card {
  perspective: 1000px;
  width: 260px;
  height: 280px;
  margin: 10px;
  border-radius: 16px;
  transition: transform 0.2s;
  position: relative;
}
.flip-card-inner {
  transition: transform 0.6s ease;
  transform-style: preserve-3d;
  position: relative;
  width: 100%;
  height: 100%;
}
.flip-card.pinned .flip-card-inner {
  transform: rotateY(180deg) !important;
}
.flip-card:hover .flip-card-inner:not(.pinned) {
  transform: rotateY(180deg);
}
.flip-card-front,
.flip-card-back {
  position: absolute;
  width: 100%;
  height: 100%;
  backface-visibility: hidden;
  border-radius: 16px;
  background: #fff;
  box-shadow: 0 6px 16px rgba(0,0,0,0.08);
  padding: 14px;
  box-sizing: border-box;
}
.flip-card-back {
  transform: rotateY(180deg);
}

.card-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 6px;
  margin-bottom: 8px;
}
.job-source-icon {
  font-size: 18px;
}

.chart-center {
  width: 100%;
  height: 140px;
  position: relative;
  display: flex;
  justify-content: center;
  align-items: center;
}

.chart-center canvas {
  width: 100% !important;
  height: 100% !important;
}
.chart-legend-stats {
  font-size: 12px;
  padding-top: 8px;
}

.chart-legend-stats div {
  display: flex;
  align-items: center;
  gap: 6px;
  margin-bottom: 2px;
}
.chart-legend-stats span.dot {
  width: 10px;
  height: 10px;
  border-radius: 50%;
  display: inline-block;
}

.dot.active { background-color: #34a853; }
.dot.expired { background-color: #ea4335; }
.dot.archived { background-color: #9aa0a6; }
.card-description {
  font-size: 13px;
  color: #333;
  line-height: 1.5;
  margin-top: 20px;
}

.pin-control {
  text-align: right;
  font-size: 11px;
  display: flex;
  align-items: center;
  gap: 6px;
}

.pin-btn {
  background: none;
  border: none;
  font-size: 18px;
  cursor: pointer;
  margin-right: 4px;
}

.drag-icon {
  font-size: 14px;
  opacity: 0.6;
  cursor: move;
  margin-left: auto;
  user-select: none;
}

.nav-right .dropdown {
  display: inline-block;
  position: relative;
}

.nav-right .dropdown-btn {
  background: #007bff;
  color: #fff;
  border: none;
  padding: 8px 14px;
  border-radius: 5px;
  cursor: pointer;
}

.nav-right .dropdown-content {
  display: none;
  position: absolute;
  top: 110%;
  right: 0;
  background-color: #fff;
  min-width: 180px;
  box-shadow: 0 8px 16px rgba(0,0,0,0.2);
  border-radius: 8px;
  z-index: 1000;
  overflow: hidden;
}

.nav-right .dropdown-content a {
  padding: 10px 16px;
  display: block;
  color: #333;
  text-decoration: none;
  font-size: 14px;
}

.nav-right .dropdown-content a:hover {
  background-color: #f0f0f0;
}


.dropdown-menu-custom {
  display: none;
  position: absolute;
  right: 0;
  top: 120%;
  background: white;
  box-shadow: 0 8px 16px rgba(0,0,0,0.15);
  border-radius: 10px;
  z-index: 999;
  min-width: 180px;
  padding: 10px;
}

.dropdown-link {
  display: block;
  padding: 10px 14px;
  border-radius: 8px;
  margin-bottom: 6px;
  background-color: #f7f9fc;
  text-decoration: none;
  color: #333;
  transition: 0.3s ease;
}

.dropdown-link:hover {
  background-color: #e8f0fe;
  color: #000;
}

.dropdown-link.logout {
  background-color: #ffecec;
  color: #a00;
}

.dropdown-link.logout:hover {
  background-color: #f8d7da;
  color: #800;
}



/*--------------------------------------------------------------------------12/06/2025*/

    footer {
      text-align: center;
      padding: 20px;
      font-size: 14px;
      color: #888;
    }

   
  </style>
</head>
<body class="function-menu">
<!-- ✅ NAVIGATION -->
<div class="custom-navbar">
  <div class="nav-left">
    <a href="#" onclick="scrollToTop(); return false;">
      <img src="images/logo.png" alt="Logo" class="logo">
    </a>
  </div>
 <div class="nav-center">
  <a href="javascript:void(0)" onclick="openModal('register.php?page=register_jobseeker')">Jobseeker Register</a>
  <a href="javascript:void(0)" onclick="openModal('register.php?page=register_employer')">Employer Register</a>
  <button class="dashboard-toggle-btn top" onclick="toggleDashboardCards()" id="dashToggleBtnTop">
    Hide Dashboard
  </button>
</div>
<div class="nav-right" style="position: relative; margin-right: 20px;">
  <div class="dropdown">
    <button type="button" class="btn btn-outline-light dropdown-toggle" onclick="toggleUserMenu()" style="border-radius: 20px; padding: 6px 16px;">
      👤 <?= isLogged() ? $_SESSION["UserID"] : "Guest" ?> ▼
    </button>

    <div id="userMenuDropdown" class="dropdown-menu-custom">
      <?php if (!isLogged()) { ?>
        <a href="javascript:void(0);" class="dropdown-link" onclick="openModal('login.php'); closeUserMenu();">🔐 Login</a>
      <?php } else { ?>
        <a href="userinfo.php" class="dropdown-link">👤 User Profile</a>
        <a href="changepwd.php" class="dropdown-link">🔐 Change Password</a>
        <a href="login.php?a=logout" onclick="return confirm('Are you sure you want to log out?');" class="dropdown-link logout">🚪 Log Out</a>
      <?php } ?>
    </div>
  </div>
</div>
</div>

<!-- ✅ HEADER SECTION -->
<header>
<h1>Welcome, {$username}</h1>
  <p>Jobseeker Dashboard</p>
</header>
 
<!-- ✅ DASHBOARD AREA -->
<br>
<div class="dashboard-filters" id="dashboardFilters"style="text-align:center;">
  <button id="toggleChartBtn" class="filter-btn red" onclick="toggleUserPostedChart()">📉 Hide Chart</button>
  <button id="filterAll" class="filter-btn blue">📊 All Data</button>
  <button id="filterMonth" class="filter-btn green">🗓 This Month</button>
  <button id="filter12mo" class="filter-btn purple">📅 Last 12 Months</button>
  <button id="downloadBtn">⬇️ Download</button>
</div>
<div class="chart-container-user-posted dashboard-chart-wrapper" id="dashboardCharts">
  <h3 style="text-align:center;">
    User-Posted Jobs by Location – {$filter_label}
    <span style="font-size: 16px; color: #666;">(Total: {$chart_total})</span>
  </h3>
  <canvas id="productChart" width="900" height="220"></canvas>
</div>

<div class="dashboard" id="dashboard">
<!-- GOVT -->
  <!-- Flip Card Template -->
  <div class="flip-card draggable" id="card_govt">
    <div class="flip-card-inner" id="govt_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟩</span>
            <strong>Government Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_govt', 'govt_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="govtChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="govt_active_pct"></span> {$govt_active}</div>
          <div><span class="dot expired"></span> <span id="govt_expired_pct"></span> {$govt_expired7}</div>
          <div><span class="dot archived"></span> <span id="govt_archived_pct"></span> {$govt_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟩</span>
            <strong>Government Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_govt', 'govt_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
These jobs are posted by government ministries or agencies. Most roles have fixed expiry dates and are managed via official HR systems.
</div>

        </div>
      </div>
    </div>
  </div>

 
  <!-- sprep -->
  <div class="flip-card draggable" id="card_sprep">
    <div class="flip-card-inner" id="sprep_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟧</span>
            <strong>SPREP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_sprep', 'sprep_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="sprepChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="sprep_active_pct"></span> {$sprep_active}</div>
          <div><span class="dot expired"></span> <span id="sprep_expired_pct"></span> {$sprep_expired7}</div>
          <div><span class="dot archived"></span> <span id="sprep_archived_pct"></span> {$sprep_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟧</span>
            <strong>SPREP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_sprep', 'sprep_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs posted by the Secretariat of the Pacific Regional Environment Programme. Often focused on climate, conservation, and sustainability.
</div>

      </div>
    </div>
  </div>
 
    <!-- spc -->
  <div class="flip-card draggable" id="card_spc">
    <div class="flip-card-inner" id="spc_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟪</span>
            <strong>SPC Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_spc', 'spc_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="spcChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="spc_active_pct"></span> {$spc_active}</div>
          <div><span class="dot expired"></span> <span id="spc_expired_pct"></span> {$spc_expired7}</div>
          <div><span class="dot archived"></span> <span id="spc_archived_pct"></span> {$spc_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟪</span>
            <strong>SPC Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_spc', 'spc_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Positions offered by the Pacific Community (SPC), covering health, education, agriculture, and regional development sectors.
</div>

      </div>
    </div>
  </div>
 
    <!-- undp -->
  <div class="flip-card draggable" id="card_undp">
    <div class="flip-card-inner" id="undp_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟥</span>
            <strong>UNDP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_undp', 'undp_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="undpChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="undp_active_pct"></span> {$undp_active}</div>
          <div><span class="dot expired"></span> <span id="undp_expired_pct"></span> {$undp_expired7}</div>
          <div><span class="dot archived"></span> <span id="undp_archived_pct"></span> {$undp_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟥</span>
            <strong>UNDP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_undp', 'undp_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Vacancies from the United Nations Development Programme. These often involve policy, climate resilience, or technical advisory roles.
</div>

      </div>
    </div>
  </div>
 
    <!-- pifs -->
  <div class="flip-card draggable" id="card_pifs">
    <div class="flip-card-inner" id="pifs_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟨</span>
            <strong>PIFS Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pifs', 'pifs_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="pifsChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="pifs_active_pct"></span> {$pifs_active}</div>
          <div><span class="dot expired"></span> <span id="pifs_expired_pct"></span> {$pifs_expired7}</div>
          <div><span class="dot archived"></span> <span id="pifs_archived_pct"></span> {$pifs_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟨</span>
            <strong>PIFS Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pifs', 'pifs_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs listed by the Pacific Islands Forum Secretariat. Focused on regional cooperation, diplomacy, and policy development.
</div>

      </div>
    </div>
  </div>
 
   <!-- ffa -->
  <div class="flip-card draggable" id="card_ffa">
    <div class="flip-card-inner" id="ffa_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🪟</span>
            <strong>FFA Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_ffa', 'ffa_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="ffaChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="ffa_active_pct"></span> {$ffa_active}</div>
          <div><span class="dot expired"></span> <span id="ffa_expired_pct"></span> {$ffa_expired7}</div>
          <div><span class="dot archived"></span> <span id="ffa_archived_pct"></span> {$ffa_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🪟</span>
            <strong>FFA Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_ffa', 'ffa_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Roles from the Pacific Islands Forum Fisheries Agency, often technical and regional in nature, especially fisheries compliance and policy.
</div>

      </div>
    </div>
  </div>
 
    <!-- pjn -->
  <div class="flip-card draggable" id="card_pjn">
    <div class="flip-card-inner" id="pjn_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">📂</span>
            <strong>Pacific Vacancies Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pjn', 'pjn_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="pjnChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="pjn_active_pct"></span> {$pjn_active}</div>
          <div><span class="dot expired"></span> <span id="pjn_expired_pct"></span> {$pjn_expired7}</div>
          <div><span class="dot archived"></span> <span id="pjn_archived_pct"></span> {$pjn_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">📂</span>
            <strong>Pacific Vacancies Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pjn', 'pjn_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Curated job opportunities from multiple Pacific organizations and private sectors, collected to support regional talent access.
</div>

      </div>
    </div>
  </div>
 
    <!-- user -->
  <!-- Flip Card Template -->
  <div class="flip-card draggable" id="card_user">
    <div class="flip-card-inner" id="user_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟦</span>
            <strong>User-Posted Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_user', 'user_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="userChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="user_active_pct"></span> {$user_active}</div>
          <div><span class="dot expired"></span> <span id="user_expired_pct"></span> {$user_expired7}</div>
          <div><span class="dot archived"></span> <span id="user_archived_pct"></span> {$user_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Description -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟦</span>
            <strong>User-Posted Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_user', 'user_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs manually submitted by employers or recruiters on this platform. These listings follow platform expiry, extension, and archive rules.
</div>

      </div>
    </div>
  </div>
</div>



<!-- 📢 Job Feed Disclaimer & Guest Prompt -->
<div id="disclaimerPopup" class="disclaimer-popup-centered">
  <div class="popup-content">
    <h4 style="margin-bottom: 4px;">📢 Job Sources & Feed <i class="fas fa-info-circle"></i> Disclaimer</h4>
    <small style="font-size: 12px; color: #666;">Transparency notice for all listed opportunities</small>

    <p>This live feed highlights job opportunities from the career pages of regional organizations like SPREP, SPC, PIFS, FFA, and UNDP, government listings from the Samoa Public Service Commission (PSC), and postings from government-owned corporations. It also includes remote global live-feed API job listings from platforms like the Himalayas.</p>

    <p>These listings help jobseekers discover local, regional, and international employment opportunities. Please note that all application procedures, rights, and recruitment decisions are the sole responsibility of the respective hiring organizations or agencies.</p>

    <hr style="margin: 10px 0;">

    <p style="font-weight: bold; font-size: 14px;">👋 Welcome, Guest!</p>
    <p 🧑‍💼 style="font-size: 13px;">To apply for jobs posted by <strong>Private Sector Employers</strong> or receive alerts for <strong>Public Sector</strong> opportunities listed on this platform, please register below:</p>

    <div class="guest-popup-buttons" style="display: flex; gap: 10px; margin-bottom: 12px;">
      <button onclick="openModal('register.php?page=register_jobseeker')" class="btn btn-sm btn-primary">Jobseeker Register</button>
      <button onclick="openModal('register.php?page=register_employer')" class="btn btn-sm btn-success">Employer Register</button>
    </div>
   
    <div style="margin-top: 10px; display: flex; align-items: center; gap: 8px;">
    <input type="checkbox" id="dontShowAgain" style="transform: scale(1.2);" />
    <label for="dontShowAgain" style="font-size: 13px;">Don’t show this again for 7 days</label>
    </div>
   
    <button class="btn btn-sm btn-secondary" onclick="toggleDisclaimerPopup()">Close</button>
  </div>
</div>


<!-- 🌐 Collapsible Floating Panel -->
<div id="floatingPanel" class="floating-panel collapsed">
  <button class="panel-toggle" onclick="togglePanel()">☰</button>

  <div class="panel-buttons">
    <button onclick="toggleDisclaimerPopup()">Disclaimer ℹ️</button>
    <button onclick="openContactModal()">Contact Us 📧</button>
    <button onclick="openChat()">Chat 💬</button>
    <?php if (!isLogged()) { ?>
      <button onclick="openModal('login.php')">Login 🔐</button>
    <?php } else { ?>
      <a href="login.php?a=logout" class="logout-btn">Logout 🔓</a>
    <?php } ?>
  </div>
</div>


<!-- ✅ Job Cards -->
<div class="jobs-grid" id="jobsContainer">
  {$job_cards}
</div>
<!-- ✅ EXTERNAL SOURCES IF ANY -->
<div class="external-jobs-wrapper">
  {$external_jobs}
</div>
<!-- ✅ MODALS (Standard + Remote Jobs) -->
<div id="customModal">
  <div class="modal-content">
    <button class="modal-close" onclick="closeModal()">✖</button>
    <iframe id="modalFrame" src="" width="100%" height="100%" style="border:none;"></iframe>
  </div>
</div>
<div id="remoteJobModal">
  <div class="modal-content">
    <button class="modal-close" onclick="closeRemoteJobModal()">×</button>
    <iframe id="remoteJobFrame" src="" allowfullscreen></iframe>
  </div>
</div>

<!-- 🧩 Footer -->
<footer style="text-align: center;">Copyright
  &copy; <?= date('Y') ?>
  <a href="https://mcil.gov.ws/" target="_blank" title="Visit MCIL website">Ministry of Commerce, Industry and Labour</a>
  |
  Developed by
  <a href="https://bitsolution.ws/" target="_blank" title="Visit developer's website">Bitsolution</a>
</footer>

<script>
// 🔽 This function toggles the dropdown menu when you click the user button
function toggleDropdown() {
  document.getElementById("profileDropdown").classList.toggle("show");
}

// 🖱️ This global click handler closes the dropdown when clicking outside of it
window.onclick = function(event) {
  // If the clicked element is NOT inside a dropdown...
  if (!event.target.closest('.dropdown')) {
    // Hide all elements with the class 'dropdown-content'
    document.querySelectorAll(".dropdown-content").forEach(drop => {
      drop.classList.remove("show");
    });
  }
}
</script>





<!-- Chart.js -->
<!-- Load Chart.js and the Data Labels plugin -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>

<script>
// 📊 Chart instance reference and default type
let chartInstance = null;
let currentType = 'bar';

// 📁 Chart data passed from PHP (PHPRunner variables)
const allData = {
  labels: {$chart_labels},              // X-axis labels
  values: {$chart_values},              // Y-axis values
  year: "<?php echo $selected_year ?>"  // Selected year
};

// 🔧 Main function to draw the chart
function drawChart(type = 'bar') {
  const ctx = document.getElementById('productChart').getContext('2d');

  // If a chart already exists, destroy it before redrawing
  if (chartInstance) chartInstance.destroy();

  // Create new chart
chartInstance = new Chart(ctx, {
    type: type,
    data: {
      labels: allData.labels,
      datasets: [{
        label: '',
        data: allData.values,
        backgroundColor: [
          '#007BFF', '#28A745', '#DC3545', '#FFC107', '#6F42C1', '#17A2B8'
        ],
        borderRadius: 6
      }]
    },
    options: {
      responsive: true,
      plugins: {
        // 🎯 Show labels directly on top of bars (if bar chart)
        datalabels: {
          display: type === 'bar',
          anchor: 'end',
          align: 'top',
          font: {
            weight: 'bold'
          }
        },
        legend: {
          display: type !== 'bar' // Only show legend for non-bar charts
        },
        title: {
          display: false // Title is hidden (you can enable it if you want)
        }
      },
      animation: {
        duration: 1000,
        easing: 'easeOutBounce'
      },
      scales: type === 'bar' ? {
        y: {
          beginAtZero: true
        }
      } : {} // No Y-axis if not bar
    },
    plugins: [ChartDataLabels]
  });
}


// 🔄 Toggle between bar and pie chart views
function toggleChartType() {
  currentType = currentType === 'bar' ? 'pie' : 'bar';
  drawChart(currentType);
}

// ⬇️ Export the chart as a PNG image
function downloadChart() {
  const link = document.createElement('a');
  link.download = 'product_chart.png';
  link.href = chartInstance.toBase64Image(); // Convert chart to image
  link.click();
}

// 📅 Apply year-based filter to reload the page with a query string
function filterByYear(year) {
  if (year === "all") {
    window.location.href = window.location.pathname;
  } else {
    const params = new URLSearchParams(window.location.search);
    params.set('year', year);
    window.location.search = params.toString();
  }
}

// 🧠 Draw chart after page is fully loaded
document.addEventListener("DOMContentLoaded", () => {
  drawChart();
});
</script>


<script>
// 🪟 Function to open a modal and load a URL in the iframe
function openModal(url) {
  event.preventDefault(); // Prevent the default link or button behavior

  const modal = document.getElementById("customModal");     // Modal container
  const frame = document.getElementById("modalFrame");      // The iframe inside the modal

  frame.src = url;                // Set the iframe's source to the provided URL
  modal.style.display = "flex";  // Show the modal (flex to center it)
  document.body.style.overflow = 'hidden'; // Prevent page scroll while modal is open
}

// ❌ Function to close the modal
function closeModal() {
  const modal = document.getElementById("customModal");
  const frame = document.getElementById("modalFrame");

  modal.style.display = "none";  // Hide the modal
  frame.src = "";                // Clear the iframe content
  document.body.style.overflow = ''; // Re-enable scrolling on the page
}
</script>



<script>
// 📌 Store the previous scroll position
let lastScrollY = window.scrollY;

// 🎯 Target the page header element
const header = document.querySelector("header");

// 🚀 Listen for scroll events
window.addEventListener("scroll", () => {
  const currentScrollY = window.scrollY;

  // 📦 Add 'shadow' and 'shrink' classes when scrolled more than 80px
  if (currentScrollY > 80) {
    header.classList.add("shadow", "shrink");
  } else {
    header.classList.remove("shadow", "shrink");
  }

  // 👻 Hide header if scrolling down fast past 150px
  if (currentScrollY > lastScrollY && currentScrollY > 150) {
    header.classList.add("hidden");
  } else {
    header.classList.remove("hidden");
  }

  // 🔁 Update scroll position
  lastScrollY = currentScrollY;
});
</script>


<script>
// 🔍 Main function to filter jobs based on keyword, category, and state
function filterJobs(keyword) {
  keyword = keyword.toLowerCase(); // Convert keyword to lowercase for case-insensitive matching

  const selectedState = document.getElementById("filterState").value.toLowerCase();   // Selected State
  const catFilter = document.getElementById("filterCategory").value.toLowerCase();    // Selected Category

  // Loop through each job card
  document.querySelectorAll('.card').forEach(card => {
    const title = card.querySelector('.job-title').textContent.toLowerCase();         // Job Title
    const category = card.getAttribute('data-category')?.toLowerCase() || "";         // Job Category (from data-attribute)
    const state = card.getAttribute('data-state')?.toLowerCase() || "";               // Job State (from data-attribute)

    const matchesCat = !catFilter || category.includes(catFilter);     // Match if no filter or category matches
    const matchesState = !selectedState || state.includes(selectedState); // Same logic for state
    const matchesTitle = title.includes(keyword);                     // Title match

    // 👁 Show or hide the card based on matching logic
    card.style.display = (matchesTitle && matchesCat && matchesState) ? 'block' : 'none';
  });
}

// 🧭 These trigger the main filterJobs() when dropdown filters change
function filterByCategory(category) {
  const keyword = document.querySelector('input[type=text]').value;
  filterJobs(keyword);
}

function filterJobsByState(state) {
  const keyword = document.querySelector('input[type=text]').value;
  filterJobs(keyword);
}

// ⬇️ Export filtered jobs to CSV file
function exportCSV() {
  let csv = "Title,Company,City,Posted,Expires\n"; // CSV Header

  // Loop through visible job cards and extract text
  document.querySelectorAll('.card').forEach(card => {
    const title = card.querySelector('.job-title').textContent.trim(); // Job title

    const meta = card.querySelectorAll('.job-meta')[0].innerText.split('\n'); // Meta lines (assumes 4 lines)
    csv += `${title},${meta[0].split(': ')[1]},${meta[1].split(': ')[1]},${meta[2].split(': ')[1]},${meta[3].split(': ')[1]}\n`;
  });

  // Encode the CSV as a downloadable link
  const encodedUri = encodeURI('data:text/csv;charset=utf-8,' + csv);
  const link = document.createElement('a');
  link.setAttribute('href', encodedUri);
  link.setAttribute('download', 'jobs_list.csv');

  // Trigger download
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
}
</script>


<script>
// 🗺️ Filter jobs based on selected state, title input, and category filter
function filterByState(state) {
  state = state.toLowerCase(); // Ensure case-insensitive comparison

  const titleInput = document.querySelector('input[type=text]').value.toLowerCase();   // Keyword typed in
  const catFilter = document.getElementById("filterCategory").value.toLowerCase();     // Selected category

  // 🔁 Loop through all job cards
  document.querySelectorAll('.card').forEach(card => {
    const description = card.innerText.toLowerCase();                                   // Entire card text
    const stateMatches = !state || description.includes(state);                         // True if no state filter or match
    const titleMatch = card.querySelector('.job-title').textContent.toLowerCase().includes(titleInput); // Title match
    const catMatch = !catFilter || card.getAttribute('data-category')?.toLowerCase().includes(catFilter); // Category match

    // 👁 Show or hide card based on combined matching rules
    card.style.display = (stateMatches && titleMatch && catMatch) ? 'block' : 'none';
  });
}
</script>


<script>
// 🪟 Open a popup modal and load a page into the iframe
function openPopup(url) {
  const modal = document.getElementById("customModal");   // The modal container
  const iframe = document.getElementById("modalFrame");   // The iframe inside the modal

  iframe.src = url;                // Load the requested page in the iframe
  modal.style.display = "flex";   // Show the modal using flexbox
  document.body.style.overflow = "hidden"; // Prevent background scrolling
}
</script>


<script>
// 📩 Listen for messages sent from an iframe (usually after a form submit)
window.addEventListener("message", function(event) {
  // ✅ If the message from the iframe is exactly 'application_success'
  if (event.data === "application_success") {
    // ❌ Close the modal (assumes you're using Bootstrap modal)
    $('#applyModal').modal('hide');

    // ✅ Show success toast notification
    const toast = new bootstrap.Toast(document.getElementById('applicationToast'));
    toast.show();
  }
});
</script>


<script>
// 🔁 Toggle between showing preview and full description in job cards
function toggleDescription(link) {
  // 🔍 Find the preview and full description elements
  const preview = link.previousElementSibling.previousElementSibling; // The short preview
  const full = link.previousElementSibling;                           // The full description

  // 🎭 Show or hide full/preview description
  if (full.style.display === "none") {
    preview.style.display = "none";      // Hide preview
    full.style.display = "inline";       // Show full text
    link.textContent = "Show less";      // Update link text
  } else {
    preview.style.display = "inline";    // Show preview again
    full.style.display = "none";         // Hide full description
    link.textContent = "Read more";      // Reset link text
  }
}
</script>


<script>
// 🔁 Toggle between preview and full location display
function toggleLocation(link) {
  const preview = link.previousElementSibling.previousElementSibling; // Short version
  const full = link.previousElementSibling;                           // Full location

  if (full.style.display === "none") {
    preview.style.display = "none";
    full.style.display = "inline";
    link.textContent = "Show less";
  } else {
    preview.style.display = "inline";
    full.style.display = "none";
    link.textContent = "Read more";
  }
}
</script>

<script>
// ❌ Close the guest welcome popup
function closeGuestPopup() {
  const popup = document.getElementById("guestPopup");
  popup.style.display = "none";
}
</script>

<script>
// 📢 Show a message prompting guests to register before applying
function showApplyMessage(btn, jobId) {
  // ✅ If the user is already logged in, do nothing
  if (<?php echo json_encode(isLogged()); ?>) return;

  // 🔍 Check if the popup already exists
  let existing = btn.parentElement.querySelector('.apply-message-popup');

  // 🧱 If not, create and insert it
  if (!existing) {
    const div = document.createElement('div');
    div.className = 'apply-message-popup';
    div.innerHTML = `
      You need to register to apply.<br>
      <button onclick="openModal('register.php?page=register_jobseeker')">Register</button>
    `;
    btn.parentElement.appendChild(div);
  }

  // 📣 Show the popup
  btn.parentElement.querySelector('.apply-message-popup').style.display = 'block';

  // ⏱ Hide it after 6 seconds
  setTimeout(() => {
    const popup = btn.parentElement.querySelector('.apply-message-popup');
    if (popup) {
      popup.style.display = 'none';
    }
  }, 6000);
}
</script>

<script>
// 🌐 Open remote job modal and load external job URL in iframe
function openRemoteJobModal(url) {
  document.getElementById('remoteJobFrame').src = url;         // Load the job URL
  document.getElementById('remoteJobModal').style.display = 'flex'; // Show modal
  document.body.style.overflow = 'hidden';                     // Disable background scroll
}

// ❌ Close the modal and clear iframe content
function closeRemoteJobModal() {
  document.getElementById('remoteJobModal').style.display = 'none'; // Hide modal
  document.getElementById('remoteJobFrame').src = '';               // Clear iframe
  document.body.style.overflow = '';                                // Restore scroll
}

// 🖱 Close modal if user clicks outside the iframe content area
window.addEventListener('click', function(e) {
  const modal = document.getElementById('remoteJobModal');

  // Only close if the actual background (not the iframe) was clicked
  if (e.target === modal) {
    closeRemoteJobModal();
  }
});
</script>

<script>
// 📂 Scroll to a category section when it's selected from the dropdown
document.getElementById("category").addEventListener("change", function() {
  const value = this.value; // Get the selected category value
  const el = document.getElementById("category-" + value); // Match corresponding section ID

  // 🧭 Scroll to the element smoothly if it exists
  if (el) {
    el.scrollIntoView({
      behavior: "smooth", // Smooth scroll effect
      block: "start"      // Align to top of the page
    });
  }
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
  const wrapper = document.querySelector(".external-jobs-wrapper"); // Container for remote jobs

  // 🔁 Function to fetch jobs from the server using AJAX
  function fetchRemoteJobs(page) {
    // ⏳ Show a loading animation while fetching
    wrapper.innerHTML = `
      <div class="loader">
        Loading<span class="dot">.</span><span class="dot">.</span><span class="dot">.</span>
      </div>
    `;

    // 📡 Fetch the remote job listings
    fetch(`jobsjobs_list.php?page=${page}&ajax_remote_jobs=1`)
      .then(res => res.text())           // Convert response to HTML string
      .then(html => {
        const tempDiv = document.createElement("div");
        tempDiv.innerHTML = html;
        tempDiv.style.opacity = 0;
        tempDiv.style.transition = "opacity 0.4s ease, transform 0.4s ease";
        tempDiv.style.transform = "translateX(30px)";

        // 🔄 Replace current job listings with new content
        wrapper.innerHTML = '';
        wrapper.appendChild(tempDiv);

        // ✨ Animate fade-in after short delay
        setTimeout(() => {
          tempDiv.style.opacity = 1;
          tempDiv.style.transform = "translateX(0)";
        }, 50);
      });
  }

//_________________________________________________________________________________________________New

function animateNewCards() {
  document.querySelectorAll('.job-card').forEach((card, index) => {
    setTimeout(() => {
      card.classList.add('highlight-card');
      setTimeout(() => {
        card.classList.remove('highlight-card');
      }, 900); // match animation duration
    }, index * 100); // slight stagger between cards
  });
}

//________________________________________________________________________________________________New

  // 🖱 Listen for clicks on pagination links
  document.body.addEventListener("click", function (e) {
    if (e.target.classList.contains("page-link")) {
      e.preventDefault();
      const page = e.target.dataset.page; // Get the page number from data-page attribute
      fetchRemoteJobs(page);             // Load jobs via AJAX
    }
  });
});
</script>

<script>
// 🪟 Open a modal and load content via URL in iframe
function openModalWithContent(url) {
  const iframe = document.getElementById("modalFrame");
  iframe.src = url; // Load external content
  document.getElementById("customModal").style.display = "flex"; // Show modal
  document.body.style.overflow = 'hidden'; // Prevent background scroll
}

// ❌ Close the modal and clear the iframe
function closeModal() {
  const iframe = document.getElementById("modalFrame");
  iframe.src = ""; // Clear iframe
  document.getElementById("customModal").style.display = "none"; // Hide modal
  document.body.style.overflow = ''; // Restore scrolling
}
</script>

<script>
// 🔍 On scroll, resize the logo for a sleek effect
window.addEventListener("scroll", function () {
  const logo = document.querySelector(".logo");     // Logo image element
  const header = document.querySelector("header");  // Main page header

  // 🎯 If user scrolls down more than 80px, shrink the logo
  if (window.scrollY > 80) {
    logo.style.transform = "scale(0.8)";
  } else {
    logo.style.transform = "scale(1)";
  }
});
</script>

<script>
// 🧠 Wait until the document is fully loaded
document.addEventListener("DOMContentLoaded", function () {
  const logo = document.querySelector(".logo");    // Your logo element
  const header = document.querySelector("header"); // The header you want to observe

  // 👁️ Create an IntersectionObserver to monitor header visibility
  const observer = new IntersectionObserver(
    ([entry]) => {
      if (entry.isIntersecting) {
        // ✅ Header is visible — restore full logo size
        logo.classList.remove("shrink");
      } else {
        // 🔽 Header is out of view — shrink the logo
        logo.classList.add("shrink");
      }
    },
    {
      threshold: 0.1 // Trigger the callback when 10% of the header is visible
    }
  );

  // 🚀 Start observing the header
  if (header) {
    observer.observe(header);
  }
});
</script>

<script>
function dismissNoJobs() {
  const alert = document.getElementById('noJobsAlert');
  alert.style.opacity = '0';
  alert.style.transform = 'translateY(-20px)';
  setTimeout(() => alert.style.display = 'none', 400);
}
</script>

<style>
/* Animation when card appears */
.slide-in {
  animation: slideFadeIn 0.8s ease-out;
}

@keyframes slideFadeIn {
  from {
    transform: translateY(30px);
    opacity: 0;
  }
  to {
    transform: translateY(0px);
    opacity: 1;
  }
}
</style>

<script>
// 🎯 Toggle popup and store dismiss state
function toggleDisclaimerPopup() {
  const popup = document.getElementById("disclaimerPopup");
  const trigger = document.getElementById("disclaimerTrigger");
  const dontShow = document.getElementById("dontShowAgain");
  const toast = document.getElementById("toastDisclaimer");

  const isHidden = popup.style.display === "none" || !popup.style.display;
  popup.style.display = isHidden ? "block" : "none";
  trigger.style.display = isHidden ? "none" : "block";

  if (!isHidden) {
    const dismissUntil = dontShow?.checked
      ? Date.now() + 7 * 24 * 60 * 60 * 1000 // 7 days
      : Date.now() + 1 * 60 * 60 * 1000;     // 1 hour

    localStorage.setItem("jobDisclaimerDismissedUntil", dismissUntil);

    // ✅ Show toast if checkbox was ticked
    if (dontShow?.checked && toast) {
      toast.style.display = "block";
      setTimeout(() => {
        toast.style.display = "none";
      }, 4000); // hide after 4 seconds
    }
  }
}

document.addEventListener("DOMContentLoaded", function () {
  const jobCards = document.getElementById("jobsContainer");
  const externalJobs = document.querySelector(".external-jobs-wrapper");
  const popup = document.getElementById("disclaimerPopup");
  const trigger = document.getElementById("disclaimerTrigger");

  const hasJobs = jobCards && jobCards.innerHTML.trim() !== "";
  const hasExternal = externalJobs && externalJobs.innerHTML.trim() !== "";

  const storedTime = localStorage.getItem("jobDisclaimerDismissedUntil");
  const now = Date.now();

  const isDismissed = storedTime && parseInt(storedTime) > now;

  if (!hasJobs && !hasExternal) {
    popup.style.display = "none";
    trigger.style.display = "none";
  } else {
    popup.style.display = isDismissed ? "none" : "block";
    trigger.style.display = isDismissed ? "block" : "none";
  }
});
</script>

<script>
function manualReopenDisclaimer() {
  const popup = document.getElementById("disclaimerPopup");
  const trigger = document.getElementById("disclaimerTrigger");
  if (popup && trigger) {
    popup.style.display = "block";
    trigger.style.display = "none";
  }
}

document.addEventListener("DOMContentLoaded", function () {
  const label = document.getElementById("disclaimerLastSeen");
  const timestamp = localStorage.getItem("jobDisclaimerDismissedUntil");

  if (label && timestamp) {
    const date = new Date(parseInt(timestamp));
    label.textContent = date.toLocaleString();
  } else if (label) {
    label.textContent = "Not dismissed yet.";
  }
});
</script>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
<script>
const ctx = document.getElementById('productChart').getContext('2d');
// Assigned from PHPRunner
const labels = {$chart_labels};
const values = {$chart_values};

const total = values.reduce((sum, val) => sum + val, 0);

const chart = new Chart(ctx, {
  type: 'bar',
  data: {
    labels: labels,
    datasets: [{
      label: 'Jobs by Location',
      data: values,
      backgroundColor: [
        '#007BFF', '#28A745', '#DC3545', '#FFC107', '#6F42C1', '#17A2B8'
      ],
      borderRadius: 6
    }]
  },
  options: {
    responsive: true,
    plugins: {
      tooltip: {
        callbacks: {
          label: function(context) {
            const value = context.raw;
            const percentage = ((value / total) * 100).toFixed(1);
            const jobText = value === 1 ? "Job" : "Jobs";
            return `${value} ${jobText} in ${context.label}`;
            //return `${value} ${jobText} in ${context.label} (${percentage}%)`;
          }
        }
      },
      datalabels: {
        display: true,
        anchor: 'end',
        align: 'top',
        font: {
          weight: 'bold'
        }
      },
      legend: {
        display: false
      },
      title: {
        display: false
      }
    },
    animation: {
      duration: 1000,
      easing: 'easeOutBounce'
    },
    scales: {
      y: {
        beginAtZero: true
      }
    }
  },
  plugins: [ChartDataLabels]
});
</script>

<script>
function scrollToTop() {
  window.scrollTo({
    top: 0,
    behavior: 'smooth'
  });
  const header = document.querySelector("header");
  // 👇 Add a glow or bounce effect when header becomes visible
  header.classList.add("highlight-top");
  // Remove the class after animation ends (1 second)
  setTimeout(() => {
    header.classList.remove("highlight-top");
  }, 900);
}
</script>

<script>
function openContactModal() {
  document.getElementById("contactModal").style.display = "flex";
}
function closeContactModal() {
  document.getElementById("contactModal").style.display = "none";
}
function submitContact() {
  const email = document.getElementById("contactEmail").value;
  const message = document.getElementById("contactMessage").value;
  const feedback = document.getElementById("contactFeedback");

  // TODO: replace with real AJAX or send to PHP endpoint
  feedback.innerHTML = `✅ Thank you! We'll respond shortly.`;
  document.getElementById("contactEmail").value = "";
  document.getElementById("contactMessage").value = "";
  return false;
}

function openChat() {
  alert("🔧 Chat widget integration coming soon!");
}
</script>

<script>
function togglePanel() {
  const panel = document.getElementById("floatingPanel");
  panel.classList.toggle("expanded");

  const toggleBtn = panel.querySelector(".panel-toggle");
  toggleBtn.textContent = panel.classList.contains("expanded") ? "⏶" : "☰";
}
</script>

<!-- Load Chart.js and DataLabels plugin first -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>

<!-- 📊 SCRIPT: Initialize All Charts -->
<script>
document.addEventListener("DOMContentLoaded", function () {
  const charts = [
    { id: "govtChart", data: [{$govt_active_raw}, {$govt_expired7_raw}, {$govt_archived_raw}], prefix: 'govt' },
    { id: "sprepChart", data: [{$sprep_active_raw}, {$sprep_expired7_raw}, {$sprep_archived_raw}], prefix: 'sprep' },
    { id: "spcChart", data: [{$spc_active_raw}, {$spc_expired7_raw}, {$spc_archived_raw}], prefix: 'spc' },
    { id: "undpChart", data: [{$undp_active_raw}, {$undp_expired7_raw}, {$undp_archived_raw}], prefix: 'undp' },
    { id: "pifsChart", data: [{$pifs_active_raw}, {$pifs_expired7_raw}, {$pifs_archived_raw}], prefix: 'pifs' },
    { id: "ffaChart", data: [{$ffa_active_raw}, {$ffa_expired7_raw}, {$ffa_archived_raw}], prefix: 'ffa' },
    { id: "pjnChart", data: [{$pjn_active_raw}, {$pjn_expired7_raw}, {$pjn_archived_raw}], prefix: 'pjn' },
    { id: "userChart", data: [{$user_active_raw}, {$user_expired7_raw}, {$user_archived_raw}], prefix: 'user' },
    { id: "himalayasChart", data: [0, 0, 0] }
  ];

    charts.forEach(({ id, data, prefix }) => {
    const ctx = document.getElementById(id);
    if (!ctx) return;

    const total = data.reduce((a, b) => a + b, 0);
    const percentages = data.map(v => total > 0 ? ((v / total) * 100).toFixed(1) + '%' : '0%');

    if (prefix) {
      const activeEl = document.getElementById(`${prefix}_active_pct`);
      const expiredEl = document.getElementById(`${prefix}_expired_pct`);
      const archivedEl = document.getElementById(`${prefix}_archived_pct`);
      if (activeEl) activeEl.textContent = percentages[0];
      if (expiredEl) expiredEl.textContent = percentages[1];
      if (archivedEl) archivedEl.textContent = percentages[2];
    }

    new Chart(ctx, {
      type: 'doughnut',
      data: {
        labels: ["Active", "Expired", "Archived"],
        datasets: [{
          data: data,
          backgroundColor: ["#34a853", "#ea4335", "#9aa0a6"],
          borderWidth: 0
        }]
      },
      options: {
        plugins: {
          legend: { display: false },
          datalabels: {
            color: '#fff',
            font: { weight: 'bold', size: 12 },
            formatter: (value, ctx) => {
              const sum = ctx.chart.data.datasets[0].data.reduce((a, b) => a + b, 0);
              return sum ? Math.round((value / sum) * 100) + '%' : '';
            }
          }
        },
        cutout: "70%",
        responsive: true,
        maintainAspectRatio: false
      },
      plugins: [ChartDataLabels]
    });
  });
});
</script>

<!-- 📌 DRAG + PIN SCRIPT -->
<script>
function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📌";
  }
}

function makeDraggable(selector) {
  const container = document.getElementById("dashboard");
  let dragged = null;

  document.querySelectorAll(selector).forEach(card => {
    card.setAttribute("draggable", true);

    card.addEventListener("dragstart", function (e) {
      dragged = this;
      e.dataTransfer.effectAllowed = "move";
      this.style.opacity = 0.5;
    });

    card.addEventListener("dragend", function () {
      this.style.opacity = 1;
    });

    card.addEventListener("dragover", function (e) {
      e.preventDefault();
      e.dataTransfer.dropEffect = "move";
    });

    card.addEventListener("drop", function (e) {
      e.preventDefault();
      if (dragged && dragged !== this) {
        const children = Array.from(container.children);
        const draggedIndex = children.indexOf(dragged);
        const targetIndex = children.indexOf(this);
        if (draggedIndex < targetIndex) {
          container.insertBefore(dragged, this.nextSibling);
        } else {
          container.insertBefore(dragged, this);
        }
      }
    });
  });
}

document.addEventListener("DOMContentLoaded", function () {
  makeDraggable(".draggable");
});
</script>

<script>
function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "📌";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📍";
  }
}
</script>


<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
<script>
function toggleDashboardCards() {
  const dash = document.getElementById("dashboard");
  const filters = document.getElementById("dashboardFilters");
  const charts = document.getElementById("dashboardCharts");
  const btn = document.getElementById("dashToggleBtnTop");

  dash.classList.toggle("dashboard-hidden");
  filters.classList.toggle("dashboard-filters-hidden");
  charts.classList.toggle("dashboard-charts-hidden");
  charts.classList.toggle("dashboard-chart-wrapper-hidden");

  const isHidden = dash.classList.contains("dashboard-hidden");
  btn.textContent = isHidden ? "Show Dashboard" : "Hide Dashboard";
  localStorage.setItem("dashboardVisible", isHidden ? "hidden" : "visible");

  if (!isHidden) {
    window.scrollTo({ top: 0, behavior: 'smooth' });
  }
}

document.addEventListener("DOMContentLoaded", function () {
  const dash = document.getElementById("dashboard");
  const filters = document.getElementById("dashboardFilters");
  const charts = document.getElementById("dashboardCharts");
  const btn = document.getElementById("dashToggleBtnTop");

  const dashState = localStorage.getItem("dashboardVisible");
  const isInitiallyHidden = dashState === "hidden";

  if (isInitiallyHidden) {
    dash.classList.add("dashboard-hidden");
    filters.classList.add("dashboard-filters-hidden");
    charts.classList.add("dashboard-charts-hidden", "dashboard-chart-wrapper-hidden");
    btn.textContent = "Show Dashboard";
  }
});

function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "📌";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📍";
  }
}

function toggleUserPostedChart() {
  const chart = document.getElementById("dashboardCharts");
  const filtersToHide = [
    document.getElementById("filterAll"),
    document.getElementById("filterMonth"),
    document.getElementById("filter12mo"),
    document.getElementById("downloadBtn")
  ];
  const btn = document.getElementById("toggleChartBtn");

  const isHidden = chart.classList.toggle("dashboard-charts-hidden");
  chart.classList.toggle("dashboard-chart-wrapper-hidden");

  filtersToHide.forEach(el => {
    if (isHidden) {
      el.classList.add("dashboard-buttons-hidden");
    } else {
      el.classList.remove("dashboard-buttons-hidden");
    }
  });

  btn.textContent = isHidden ? "📊 Show Chart" : "📉 Hide Chart";
}
</script>


<script>
function toggleDropdown(event) {
  event.stopPropagation();
  const dropdown = document.getElementById("profileDropdown");
  dropdown.style.display = (dropdown.style.display === "block") ? "none" : "block";
}

// Close dropdown if clicked outside
document.addEventListener("click", function (event) {
  const dropdown = document.getElementById("profileDropdown");
  const button = document.querySelector(".dropdown-btn");
  if (dropdown && dropdown.style.display === "block" && !event.target.closest('.dropdown')) {
    dropdown.style.display = "none";
  }
});
</script>

<script>
  window.addEventListener('DOMContentLoaded', () => {
    const isLoggedIn = <?= json_encode(isLogged()); ?>;

    if (isLoggedIn) {
      document.getElementById("loginform_login")?.style?.setProperty("display", "none");
      document.getElementById("logout_link")?.style?.setProperty("display", "inline-block");
    } else {
      document.getElementById("loginform_login")?.style?.setProperty("display", "inline-block");
      document.getElementById("logout_link")?.style?.setProperty("display", "none");
    }
  });
</script>

<script>
function toggleUserMenu() {
  const menu = document.getElementById("userMenuDropdown");
  menu.style.display = (menu.style.display === "block") ? "none" : "block";
}

// Auto-close when clicking outside
document.addEventListener('click', function(event) {
  const dropdown = document.getElementById("userMenuDropdown");
  const button = document.querySelector(".dropdown-toggle");
  if (!dropdown.contains(event.target) && !button.contains(event.target)) {
    dropdown.style.display = "none";
  }
});
</script>

<script>
// Toggle dropdown visibility
function toggleUserMenu() {
  const menu = document.getElementById("userMenuDropdown");
  menu.style.display = (menu.style.display === "block") ? "none" : "block";
}

// Close dropdown if clicked outside
document.addEventListener("click", function(event) {
  const dropdown = document.getElementById("userMenuDropdown");
  const button = document.querySelector(".dropdown-toggle");
  if (dropdown && dropdown.style.display === "block" && !event.target.closest('.dropdown')) {
    dropdown.style.display = "none";
  }
});

// Manually close menu
function closeUserMenu() {
  document.getElementById("userMenuDropdown").style.display = "none";
}
</script>


<!-- ananei -->

</body>
</html>
